﻿
$scriptDir = Split-Path -Parent $MyInvocation.MyCommand.Path
$utilsDir  = Join-Path -Path $scriptDir -ChildPath ..\WebSite

$filePath = "$utilsDir\web.config"

# load the XML from the web.config
$xml = New-Object XML
$xml = [xml](Get-Content $filePath)

$oconfigSections = $xml.selectSingleNode("/configuration/configSections")
if(!$oconfigSections)
{
    $configSections = $xml.CreateElement('configSections')

    $section = $xml.CreateElement('section')
    $section.SetAttribute('name','entityFramework')
    $section.SetAttribute('type','System.Data.Entity.Internal.ConfigFile.EntityFrameworkSection, EntityFramework, Version=6.0.0.0, Culture=neutral, PublicKeyToken=b77a5c561934e089')
    $section.SetAttribute('requirePermission','false')

    $configSections.AppendChild($section)

    $xml.configuration.InsertAfter($configSections, $null)
}
else
{
    $oSection = $xml.selectSingleNode("/configuration/configSections/section[@name='entityFramework']")
    if(!$oSection)
    {
        $section = $xml.CreateElement('section')
        $section.SetAttribute('name','entityFramework')
        $section.SetAttribute('type','System.Data.Entity.Internal.ConfigFile.EntityFrameworkSection, EntityFramework, Version=6.0.0.0, Culture=neutral, PublicKeyToken=b77a5c561934e089')
        $section.SetAttribute('requirePermission','false')
    
        $oconfigSections.AppendChild($section)
    }
}
$ns = New-Object System.Xml.XmlNamespaceManager($xml.NameTable)
$ns.AddNamespace("ns", "urn:schemas-microsoft-com:asm.v1")
$oassemblyBinding = $xml.SelectNodes("//ns:assemblyBinding", $ns)
$oDependentNewton = $oassemblyBinding.SelectSingleNode("//ns:dependentAssembly/ns:assemblyIdentity[@name='Newtonsoft.Json']", $ns)

if(!$oDependentNewton) 
{
    $newDependentAssembly = $xml.CreateElement("dependentAssembly", "urn:schemas-microsoft-com:asm.v1")

    $newAssemblyIdentity = $xml.CreateElement("assemblyIdentity", "urn:schemas-microsoft-com:asm.v1")
    $newAssemblyIdentity.SetAttribute("name","Newtonsoft.Json")
    $newAssemblyIdentity.SetAttribute("publicKeyToken","30ad4fe6b2a6aeed")
    $newAssemblyIdentity.SetAttribute("culture","neutral")

    $newDependentAssembly.AppendChild($newAssemblyIdentity)

    $newbindingRedirect = $xml.CreateElement("bindingRedirect", "urn:schemas-microsoft-com:asm.v1")
    $newbindingRedirect.SetAttribute("oldVersion","0.0.0.0-11.0.0.0")
    $newbindingRedirect.SetAttribute("newVersion","11.0.0.0")
    $newDependentAssembly.AppendChild($newbindingRedirect)

    $xml.configuration.runtime.assemblyBinding.AppendChild($newDependentAssembly)
}

$oentityFramework = $xml.SelectSingleNode('/configuration/entityFramework')
if(!$oentityFramework) 
{
    $f = $xml.CreateDocumentFragment()
    $f.InnerXml='
  <entityFramework>
    <defaultConnectionFactory type="System.Data.Entity.Infrastructure.LocalDbConnectionFactory, EntityFramework">
      <parameters>
        <parameter value="mssqllocaldb" />
      </parameters>
    </defaultConnectionFactory>
    <providers>
      <provider invariantName="System.Data.SqlClient" type="System.Data.Entity.SqlServer.SqlProviderServices, EntityFramework.SqlServer" />
      <provider invariantName="System.Data.SQLite.EF6" type="System.Data.SQLite.EF6.SQLiteProviderServices, System.Data.SQLite.EF6" />
    </providers>
  </entityFramework>
'
    $xml.configuration.AppendChild($f)
}

$osystemData = $xml.SelectSingleNode('/configuration/system.data')
if(!$osystemData)
{
    $f = $xml.CreateDocumentFragment()
    $f.InnerXml='
  <system.data>
    <DbProviderFactories>
      <remove invariant="System.Data.SQLite.EF6" />
      <add name="SQLite Data Provider (Entity Framework 6)" invariant="System.Data.SQLite.EF6" description=".NET Framework Data Provider for SQLite (Entity Framework 6)" type="System.Data.SQLite.EF6.SQLiteProviderFactory, System.Data.SQLite.EF6" />
      <remove invariant="System.Data.SQLite" />
      <add name="SQLite Data Provider" invariant="System.Data.SQLite" description=".NET Framework Data Provider for SQLite" type="System.Data.SQLite.SQLiteFactory, System.Data.SQLite" />
    </DbProviderFactories>
  </system.data>
'
    $xml.configuration.AppendChild($f)
}

$osystemWeb = $xml.SelectSingleNode('/configuration/system.web.extensions')
if(!$osystemWeb)
{
    $f = $xml.CreateDocumentFragment()
    $f.InnerXml='
  <system.web.extensions>
    <scripting>
      <webServices>
        <jsonSerialization maxJsonLength="209715200"/>
      </webServices>
    </scripting>
  </system.web.extensions>
'
    $xml.configuration.AppendChild($f)
}

$xml.Save($filePath)